#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <errno.h>

#include "gmstuff.h"
#include "map.h"

int Hport;
int Test_all_hports;
int Sequential;
char *Progname;

extern int optind;
extern int Test_kbytes;
extern int Test_id_pkts;
extern int Report_echo_pkts;
int test_this_route(unsigned char *route, int rlen, int report);

void
usage ()
{
  fprintf(stderr, "\n%s [-s] [-i <interface>] [-l <KBytes>] [-I <pkts>] <route>\n",
      Progname);
  fprintf(stderr, "Sends either raw data packets or xbar32 ID packet to <route>\n");
  fprintf(stderr, "\t-h:          Prints this help message\n");
  fprintf(stderr, "\t-I <pkts>:   Send <pkts> xbar32 ID packets, rx and report (default: 1)\n");
  fprintf(stderr, "\t-l <KBytes>: echo <KBytes> of raw data through <route> (defailt: 0)\n");
  fprintf(stderr, "\t-s:          Send packets sequentially further and further down the route\n");
  fprintf(stderr, "\t<route>:     Route to the xbar in hex or if appended with '--' as decimal\n");
  fprintf(stderr, "\t             offsets.\n");
  exit(1);
}

int
build_route(
  unsigned char *route,
  int rlen)
{

  int i;

  /* U-turn byte. If using xbar32 ID packets, use 0xA0, for raw data packets,
   * use a 0 to redirect the packet back to where it came from
   */
  route[rlen] = (Test_id_pkts) ? 0xA0 : DELTA_TO_ROUTE(0);

  /* then build path back to origin */
  for (i=0; i<rlen; ++i) {
    route[rlen+i+1] = DELTA_TO_ROUTE(-ROUTE_TO_DELTA(route[rlen-i-1]));
  }

  return(2 * rlen + 1);
}


void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;

  Hport = 0;
  Test_all_hports = 0;
  Sequential = 0;

  while ((c = getopt(argc, argv, "shi:l:I:")) != EOF) {
    switch (c) {

    case 'i':
      Hport = atoi(optarg);
      break;
  
    case 's':     /* seq pkts sequentiall further and futher */
      Sequential++;
      printf("-s not implemented yet\n");
      break;
  
    case 'I':     /* use ID packets (assumes xbar32's) */
      if (Test_kbytes) {
        fprintf(stderr, "Cannot specify both -l and -I\n");
        usage();
      }
      Test_id_pkts = atoi(optarg);
      assert(Test_id_pkts > 0);
      break;
  
    case 'l':
      if (Test_id_pkts) {
        fprintf(stderr, "Cannot specify both -l and -I\n");
        usage();
      }
  
      Test_kbytes = atoi(optarg);
      assert(Test_kbytes > 0);
      break;
    case 'h':
      usage();
    }
  }
}

int
main(
  int argc,
  char **argv)
{

  unsigned char route[32];
  int rlen = 0;
  int total_rlen = 0;
  int i;

  Progname = argv[0];
  Report_echo_pkts = 1;

  parse_args(argc, argv);

printf("gm version: %03x\n", GM_API_VERSION);
// printf("gm version 2_0: %03x\n", GM_API_VERSION_2_0);
  /* for now assume route bytes are hex */
  for (i = optind; i < argc; i++) {
    route[rlen++] = strtoul(argv[i], (char **)NULL, 16);
  }

  /* See if they are all valid hex route bytes */
  for (i = 0; i < rlen; i++) {
    if (!(route[i] & 0x80)) break;
  }

  /* if they aren't valid route bytes assume they are decimal */
  if (i < rlen) {
    rlen = 0;
    for (i = optind; i < argc; i++) {
      route[rlen++] = DELTA_TO_ROUTE(atoi(argv[i]));
    }
  }
      
  /* default is to send x32 ident packets */
  if (!(Test_id_pkts || Test_kbytes)) Test_id_pkts = 1;

  total_rlen = build_route(route, rlen);

  printf("total rlen: %d, route: ", total_rlen);
  for (i = 0; i < total_rlen; i++) {
    printf("%02x ", route[i]);
  }
  printf("\n");

  initialize_gm();

  test_this_route(route, total_rlen, 1);

  close_gm();

  return 0;
}
